/*
 * Decompiled with CFR 0.152.
 */
package com.android.res_table.data;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.RequestData;
import com.android.core.utils.params.QueryParamTypes;
import com.android.res_table.domain.GetReserves;
import com.dto.LoginDto;
import com.security.SecurityConstants;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.Paging;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ResTableRepository
extends AndroidRepository<Map<String, Object>> {
    @Resource
    @Lazy
    private GetReserves getReserves;

    @Autowired
    public ResTableRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    @NotNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.RES_TABLE;
    }

    public BaseResponse<Map<String, Object>> customQuery(RequestData request, Paging paging, LoginDto login) {
        String sql = this.makeSql(request, paging, login);
        if (sql == null) {
            return new BaseResponse.Builder().build();
        }
        List result = this.getJdbc(login).queryForList(sql);
        if (result.isEmpty()) {
            return new BaseResponse.Builder().build();
        }
        List reserveList = this.getReserves.invoke(result.stream().map(map -> map.get("code").toString()).collect(Collectors.toList()));
        result = result.stream().peek(tableMap -> tableMap.put("reserveList", reserveList.stream().filter(reserveMap -> reserveMap.get("tableId") == tableMap.get("code")).collect(Collectors.toList()))).collect(Collectors.toList());
        return new BaseResponse.Builder().totalPages(this.getTotalPages()).totalCount(this.getTotalCount()).data(result).build();
    }

    protected Paging.PageSqlData queryWithDefaultPaging(SettingLoader settingsLoader) {
        if (settingsLoader.sendResTablesDisabled()) {
            return null;
        }
        String whereShowOnlyThisUserInvoices = settingsLoader.showThisUserResInvoicesOnly() ? "WHERE OpenCount.UserCode = " + settingsLoader.getLogin().getUserCodeInc() + " OR OpenCount.UserCode IS NULL" : "";
        return Paging.PageSqlData.builder().selectSqlStr("SELECT Desk.id as code, RTrim(LTrim(Desk.Desk_Name)) AS title, \n Desk.[STATUS] isPresent, \n Isnull(FcPay.F_Code,0) AS lastpaycode, \n CONVERT(nvarchar(50), Isnull(Isnull(FcPay.F_Date, 0) \n + Cast(FcPay.F_Time as DateTime), 0), 120) AS lastpaydatetime, \n Isnull(FcPay.F_SumPrice, 0) AS lastpayprice, \n Isnull(FcOpen.F_Code, 0) AS lastopencode, \n CONVERT(nvarchar(50), Isnull(Isnull(FcOpen.F_Date, 0) \n + Cast(FcOpen.F_Time as DateTime), 0), 120) AS lastopendatetime, \n Isnull(FcOpen.F_SumPrice,0) AS lastopenprice, \n Isnull(OpenCount.OpenCount,0) AS opentablecount, Chair_Count, \n  (CASE WHEN FcOpen.cashAmount + FcOpen.creditAmount + FcOpen.posAmount > 0 \n  THEN 'true' ELSE 'false' END) isSettled, FcOpen.IS_OnlineFacture isOnlineFacture, \n  ISNULL(FcOpen.guestCount, 0) as guestCount \n FROM Res_Desk Desk").joinsStr(" LEFT JOIN \n (SELECT rf.F_Code, RTrim(LTrim(rf.Desk_Name)) AS Desk_Name, rf.F_Time, rf.F_Date, \n  rf.F_SumPrice \n  FROM Res_Facture rf \n  INNER JOIN( \n   SELECT MAX(rf.F_Date + CAST(rf.F_Time AS DateTime)) AS fDate, \n   RTrim(LTrim(rf.Desk_Name)) AS Desk_Name \n   FROM Res_Facture rf \n   where ISNULL(ExporterSId,0) > -1 \n   And F_Type = 2 and Fac_Type = 'R' \n   GROUP BY RTrim(LTrim(rf.Desk_Name)) \n   ) AS MaxInfo ON MaxInfo.fDate = (rf.F_Date + CAST(rf.F_Time AS DateTime)) \n    and RTrim(LTrim(MaxInfo.Desk_Name)) = RTrim(LTrim(rf.Desk_Name)) And rf.F_Type = 2 \n ) AS FcPay ON  RTrim(LTrim(Desk.Desk_Name)) = RTrim(LTrim(FcPay.Desk_Name)) \n LEFT JOIN \n (SELECT rf.F_Code, RTrim(LTrim(rf.Desk_Name)) AS Desk_Name, rf.F_Time, rf.F_Date, \n  rf.F_SumPrice, IsNull(rf.F_Naghd, 0) cashAmount, IsNull(rf.F_Nesieh, 0) creditAmount, \n  IsNull(rf.F_Pos, 0) posAmount, rf.IS_OnlineFacture as IS_OnlineFacture, rf.GuestCount as GuestCount \n  FROM Res_Facture rf \n  INNER JOIN( \n   SELECT MAX(rf.F_Date + CAST(rf.F_Time AS DateTime)) AS fDate, \n   RTrim(LTrim(rf.Desk_Name)) AS Desk_Name \n   FROM Res_Facture rf \n   where ISNULL(ExporterSId, 0) > -1 \n   And F_Type = 1 \n   and Fac_Type = 'R' \n   GROUP BY RTrim(LTrim(rf.Desk_Name)) \n  ) AS MaxInfo ON MaxInfo.fDate = (rf.F_Date + CAST(rf.F_Time AS DateTime)) \n    and RTrim(LTrim(MaxInfo.Desk_Name)) = RTrim(LTrim(rf.Desk_Name)) \n    And rf.F_Type = 1 \n ) AS FcOpen ON  RTrim(LTrim(Desk.Desk_Name)) = RTrim(LTrim(FcOpen.Desk_Name)) \n LEFT JOIN( \n  SELECT COUNT(rf.F_Code) AS OpenCount,RTrim(LTrim(rf.Desk_Name)) AS Desk_Name, UserCode \n  FROM Res_Facture rf \n  WHERE ISNULL(ExporterSId,0) > -1 \n  AND F_Type = 1 \n  AND Fac_Type = 'R' \n  Group BY RTrim(LTrim(rf.Desk_Name)), UserCode \n ) AS OpenCount ON RTrim(LTrim(OpenCount.Desk_Name)) = RTrim(LTrim(Desk.Desk_Name)) \n" + (settingsLoader.userHasLimitedAccessOnResTables() ? " INNER JOIN UserSell u ON Desk.Id = u.Accesssarfasl AND u.TypeInc = 4  AND u.UserCodeInc = " + settingsLoader.getLogin().getUserCodeInc() : "")).whereStr(whereShowOnlyThisUserInvoices).alias("Desk").keyField("[code]").build();
    }

    public BaseResponse<Map<String, Object>> setCustomerPresence(boolean isPresent, long id) {
        String sql = "UPDATE RES_DESK SET [STATUS] = ? WHERE [id] = ?";
        this.dbConnection.getJdbcTemplate(SecurityConstants.loadToken()).update("UPDATE RES_DESK SET [STATUS] = ? WHERE [id] = ?", new Object[]{isPresent ? 1 : 0, id});
        return new BaseResponse.Builder().data((Object)ConvertStr.buildMap(map -> {
            map.put("id", id);
            map.put("message", String.format("\u0648\u0636\u0639\u06cc\u062a \u0645\u06cc\u0632 \u0628\u0647 %s \u062a\u063a\u06cc\u06cc\u0631 \u06cc\u0627\u0641\u062a.", isPresent ? "\u00ab\u062d\u0636\u0648\u0631\u00bb" : "\u00ab\u0644\u063a\u0648 \u062d\u0636\u0648\u0631\u00bb"));
        })).build();
    }
}

